/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagUtils {
    private TagUtils() {
    }

    public static void buildTableStructure(Document document, Element tableElement, int rows, int cols) {
        for (int i = 0; i < rows; ++i) {
            Element tr = document.createElement("tr");
            for (int j = 0; j < cols; ++j) {
                Element td = document.createElement("td");
                td.setAttribute("nowrap", "true");
                tr.appendChild(td);
            }
            tableElement.appendChild(tr);
        }
    }

    public static Element findTable(String name, Document document) {
        NodeList nl = document.getElementsByTagName("table");
        int nlLength = nl.getLength();
        for (int i = 0; i < nlLength; ++i) {
            if (!(nl.item(i) instanceof Element) || !((Element)nl.item(i)).getAttribute("name").equals(name)) continue;
            return (Element)nl.item(i);
        }
        return null;
    }

    public static Element findCell(String cell, Element table) {
        Element tr;
        if (cell == null || cell.equals("")) {
            return null;
        }
        int column = Integer.parseInt(cell.substring(0, cell.indexOf(",")));
        int row = Integer.parseInt(cell.substring(cell.indexOf(",") + 1));
        NodeList trs = table.getElementsByTagName("tr");
        int trsLength = trs.getLength();
        int trIndex = -1;
        int x = -1;
        do {
            if (++x == trsLength) {
                int i;
                tr = table.getOwnerDocument().createElement("tr");
                table.appendChild(tr);
                ++trsLength;
                int colspan = 0;
                for (i = 0; i < trsLength; ++i) {
                    if (trs.item(i).getParentNode() != table) continue;
                    NodeList tds = ((Element)trs.item(i)).getElementsByTagName("td");
                    int tdsLength = tds.getLength();
                    for (int j = 0; j < tdsLength; ++j) {
                        Element tdtmp = (Element)tds.item(j);
                        if (tdtmp.getParentNode() != trs.item(i)) continue;
                        String tdcolspan = tdtmp.getAttribute("colspan");
                        if (tdcolspan != null && !tdcolspan.trim().equals("")) {
                            colspan += Integer.parseInt(tdcolspan);
                            continue;
                        }
                        ++colspan;
                    }
                    i = trsLength;
                }
                for (i = 0; i < colspan; ++i) {
                    Element td = table.getOwnerDocument().createElement("td");
                    td.setAttribute("nowrap", "true");
                    tr.appendChild(td);
                }
                x = -1;
                trIndex = -1;
                continue;
            }
            if (!trs.item(x).getParentNode().equals(table)) continue;
            ++trIndex;
        } while (trIndex != row);
        tr = (Element)trs.item(x);
        NodeList tds = tr.getElementsByTagName("td");
        int ptr = 0;
        int tdsLength = tds.getLength();
        for (int i = 0; i < tdsLength; ++i) {
            Element td = (Element)tds.item(i);
            if (td.getParentNode() != tr) continue;
            if (ptr == column) {
                return td;
            }
            String colspan = td.getAttribute("colspan");
            if (colspan != null && !colspan.trim().equals("")) {
                ptr += Integer.parseInt(colspan);
                continue;
            }
            ++ptr;
        }
        Element td = null;
        while (ptr <= column) {
            td = table.getOwnerDocument().createElement("td");
            td.setAttribute("nowrap", "true");
            tr.appendChild(td);
            ++ptr;
        }
        return td;
    }

    public static Element findElement(String id, Element inElement) {
        if (inElement.getAttribute("id") != null && inElement.getAttribute("id").equals(id)) {
            return inElement;
        }
        NodeList children = inElement.getChildNodes();
        int childrenLength = children.getLength();
        for (int i = 0; i < childrenLength; ++i) {
            Element returnElement;
            if (!(children.item(i) instanceof Element) || (returnElement = TagUtils.findElement(id, (Element)children.item(i))) == null) continue;
            return returnElement;
        }
        return null;
    }

    public static void adjustColspan(String colspanStr, Element tdCell) {
        if (colspanStr == null || colspanStr.trim().equals("") || tdCell == null) {
            return;
        }
        int colspan = Integer.parseInt(colspanStr);
        if (colspan == 1) {
            return;
        }
        Element tr = (Element)tdCell.getParentNode();
        NodeList trChildren = tr.getChildNodes();
        int i = 0;
        while (trChildren.item(i) != tdCell) {
            ++i;
        }
        if (colspan == 0) {
            int len = trChildren.getLength();
            int removed = 0;
            for (int x = len - 1; x > i; --x) {
                if (!(trChildren.item(x) instanceof Element) || !((Element)trChildren.item(x)).getTagName().equals("td") || trChildren.item(x).getChildNodes().getLength() != 0) continue;
                tr.removeChild(trChildren.item(x));
                ++removed;
            }
            colspanStr = new Integer(removed + 1).toString();
        } else {
            int removed = 0;
            for (int z = i + colspan - 1; z > i; --z) {
                if (!(trChildren.item(z) instanceof Element) || !((Element)trChildren.item(z)).getTagName().equals("td") || trChildren.item(z).getChildNodes().getLength() != 0) continue;
                tr.removeChild(trChildren.item(z));
                ++removed;
            }
            if (removed > 0) {
                colspanStr = new Integer(removed + 1).toString();
            }
        }
        tdCell.setAttribute("colspan", colspanStr);
    }

    public static void adjustRowspan(String rowspanStr, Element tdCell) {
        if (rowspanStr == null || rowspanStr.trim().equals("") || tdCell == null) {
            return;
        }
        int rowspan = Integer.parseInt(rowspanStr);
        if (rowspan == 1) {
            return;
        }
        tdCell.setAttribute("rowspan", rowspanStr);
    }

    public static void removeEmptyRowsFromTables(Document document) {
        int i;
        if (document == null) {
            return;
        }
        NodeList tables = document.getElementsByTagName("table");
        if (tables == null) {
            return;
        }
        for (int i2 = 0; i2 < tables.getLength(); ++i2) {
            Element table = (Element)tables.item(i2);
            NodeList trs = table.getElementsByTagName("tr");
            if (trs == null) continue;
            for (int j = trs.getLength() - 1; j >= 0; --j) {
                Element tr = (Element)trs.item(j);
                if (tr.getParentNode() != table) continue;
                if (TagUtils.isEmptyRow(tr)) {
                    table.removeChild(tr);
                    j = trs.getLength();
                    continue;
                }
                j = 0;
            }
        }
        NodeList tds = document.getElementsByTagName("td");
        if (tds == null) {
            return;
        }
        ArrayList<Node> affectedTds = new ArrayList<Node>();
        for (i = 0; i < tds.getLength(); ++i) {
            if (((Element)tds.item(i)).getAttribute("rowspan") == null || ((Element)tds.item(i)).getAttribute("rowspan").equals("")) continue;
            affectedTds.add(tds.item(i));
        }
        for (i = 0; i < affectedTds.size(); ++i) {
            TagUtils.fixRowSpan((Element)affectedTds.get(i));
            affectedTds.remove(i);
            i = -1;
        }
    }

    private static void fixRowSpan(Element tdCell) {
        Element tr = (Element)tdCell.getParentNode();
        Element table = (Element)tr.getParentNode();
        NodeList tableRows = table.getChildNodes();
        int i = 0;
        int colNum = 0;
        while (tr.getChildNodes().item(i) != tdCell) {
            Element tmpTd = (Element)tr.getChildNodes().item(i);
            if (!tmpTd.getTagName().equals("td")) continue;
            if (tmpTd.getAttribute("colspan") != null && !tmpTd.getAttribute("colspan").equals("")) {
                String colspan = tmpTd.getAttribute("colspan");
                colNum += Integer.parseInt(colspan);
            } else {
                ++colNum;
            }
            ++i;
        }
        i = 0;
        while (tableRows.item(i) != tr) {
            ++i;
        }
        int rowspan = Integer.parseInt(tdCell.getAttribute("rowspan"));
        int colsToFix = 1;
        if (tdCell.getAttribute("colspan") != null && !tdCell.getAttribute("colspan").equals("")) {
            colsToFix = Integer.parseInt(tdCell.getAttribute("colspan"));
        }
        if (rowspan == 0) {
            rowspan = tableRows.getLength() - i;
        }
        if (rowspan == 1) {
            return;
        }
        if (tableRows.getLength() - i < rowspan) {
            rowspan = tableRows.getLength() - i;
        }
        for (int z = i + 1; z < i + rowspan; ++z) {
            Element tmptr = (Element)tableRows.item(z);
            int y = 0;
            while (y < colNum) {
                Element tmptd = (Element)tmptr.getChildNodes().item(y);
                if (!tmptd.getTagName().equals("td")) continue;
                if (tmptd.getAttribute("colspan") != null && !tmptd.getAttribute("colspan").equals("")) {
                    y += Integer.parseInt(tmptd.getAttribute("colspan"));
                    continue;
                }
                ++y;
            }
            if (y != colNum) continue;
            int x = 0;
            int numRemoved = 0;
            while (x < colsToFix && y + x - numRemoved < tmptr.getChildNodes().getLength()) {
                Element tmptd = (Element)tmptr.getChildNodes().item(y + x - numRemoved);
                x = tmptd.getAttribute("colspan") != null && !tmptd.getAttribute("colspan").equals("") ? (x += Integer.parseInt(tmptd.getAttribute("colspan"))) : ++x;
                if (tmptd.getChildNodes().getLength() != 0) continue;
                tmptd.getParentNode().removeChild(tmptd);
                ++numRemoved;
            }
        }
    }

    private static boolean isEmptyRow(Element tr) {
        if (tr == null) {
            return true;
        }
        if (tr.getChildNodes() == null || tr.getChildNodes().getLength() == 0) {
            return true;
        }
        NodeList tds = tr.getElementsByTagName("td");
        if (tds == null || tds.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < tds.getLength(); ++i) {
            if (tds.item(i).getParentNode() != tr || tds.item(i).getChildNodes().getLength() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Element findParentWithTagName(Element element, String tagName) {
        if (tagName == null) {
            return element;
        }
        Element tmp = element;
        while (tmp != null && !tmp.getTagName().equals(tagName)) {
            if (tmp.getParentNode() instanceof Element) {
                tmp = (Element)tmp.getParentNode();
                continue;
            }
            tmp = null;
        }
        return tmp;
    }

    public static String adjustImageSrcPath(String path) {
        if (path == null) {
            return "";
        }
        if (path.indexOf("graphic") <= 6 && path.indexOf("graphic") >= 0) {
            return path;
        }
        int lastDot = path.lastIndexOf(".");
        int dot = path.indexOf(".");
        while (dot != lastDot) {
            path = path.substring(0, dot) + "/" + path.substring(dot + 1);
            dot = path.indexOf(".");
        }
        return "/res/" + path;
    }
}

